/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import com.sun.security.sasl.preview.RealmCallback;
import com.sun.security.sasl.preview.RealmChoiceCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

final class DefaultCallbackHandler
implements CallbackHandler {
    private char[] passwd;
    private String authenticationID;
    private String authRealm;

    DefaultCallbackHandler(String string, Object object, String string2) throws IOException {
        this.authenticationID = string;
        this.authRealm = string2;
        if (object instanceof String) {
            this.passwd = ((String)object).toCharArray();
        } else if (object instanceof char[]) {
            this.passwd = (char[])((char[])object).clone();
        } else if (object != null) {
            String string3 = new String((byte[])object, "UTF8");
            this.passwd = string3.toCharArray();
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            if (callbackArray[i] instanceof NameCallback) {
                ((NameCallback)callbackArray[i]).setName(this.authenticationID);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbackArray[i]).setPassword(this.passwd);
                continue;
            }
            if (callbackArray[i] instanceof RealmChoiceCallback) {
                String[] stringArray = ((RealmChoiceCallback)callbackArray[i]).getChoices();
                int n = 0;
                if (this.authRealm != null) {
                    n = -1;
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].equals(this.authRealm)) continue;
                        n = j;
                    }
                    if (n == -1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int j = 0; j < stringArray.length; ++j) {
                            stringBuffer.append(stringArray[j] + ",");
                        }
                        throw new IllegalArgumentException("Cannot match 'java.naming.security.sasl.realm' property value, '" + this.authRealm + "' with choices " + stringBuffer + "in RealmChoiceCallback");
                    }
                }
                ((RealmChoiceCallback)callbackArray[i]).setSelectedIndex(n);
                continue;
            }
            if (callbackArray[i] instanceof RealmCallback) {
                if (this.authRealm != null) {
                    ((RealmCallback)callbackArray[i]).setText(this.authRealm);
                    continue;
                }
                ((RealmCallback)callbackArray[i]).setText("");
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i]);
        }
    }

    void clearPassword() {
        if (this.passwd != null) {
            for (int i = 0; i < this.passwd.length; ++i) {
                this.passwd[i] = '\u0000';
            }
            this.passwd = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clearPassword();
    }
}

